/*
 * Decompiled with CFR 0.152.
 */
package ssl;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import ssl.ArmitageTrustListener;

public class ArmitageTrustManager
implements X509TrustManager {
    protected ArmitageTrustListener checker;

    public ArmitageTrustManager(ArmitageTrustListener checker) {
        this.checker = checker;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] ax509certificate, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] ax509certificate, String authType) throws CertificateException {
        try {
            for (int x = 0; x < ax509certificate.length; ++x) {
                byte[] bytesOfMessage = ax509certificate[x].getEncoded();
                MessageDigest md = MessageDigest.getInstance("SHA1");
                byte[] thedigest = md.digest(bytesOfMessage);
                BigInteger bi = new BigInteger(1, thedigest);
                String fingerprint = bi.toString(16);
                if (this.checker == null || this.checker.trust(fingerprint)) continue;
                throw new CertificateException("Certificate Rejected. Press Cancel.");
            }
            return;
        }
        catch (CertificateException cex) {
            throw cex;
        }
        catch (Exception ex) {
            throw new CertificateException(ex.getMessage());
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

