/*
 * Decompiled with CFR 0.152.
 */
package cortana.support;

import cortana.core.EventManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import msf.Async;
import msf.RpcConnection;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class LockBridge
implements Function,
Loadable,
Runnable {
    protected EventManager events;
    protected RpcConnection connection;
    protected List locks = new LinkedList();

    public LockBridge(RpcConnection connection, EventManager events) {
        this.connection = connection;
        this.events = events;
        new Thread(this).start();
    }

    public boolean acquireLock(String name, ScriptInstance script) {
        try {
            Map temp = (Map)this.connection.execute("armitage.lock", new Object[]{name, script.getName()});
            if (!temp.containsKey("error")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void releaseLock(String name) {
        try {
            ((Async)((Object)this.connection)).execute_async("armitage.unlock", new Object[]{name});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            LinkedList templ;
            LockBridge lockBridge = this;
            synchronized (lockBridge) {
                templ = new LinkedList(this.locks);
            }
            try {
                if (templ.size() == 0) {
                    Thread.sleep(2000L);
                    continue;
                }
                LinkedList<LockMinion> tempr = new LinkedList<LockMinion>();
                for (LockMinion m : templ) {
                    if (m.grab()) {
                        tempr.add(m);
                    }
                    Thread.sleep(100L);
                }
                LockBridge lockBridge2 = this;
                synchronized (lockBridge2) {
                    Iterator i = tempr.iterator();
                    while (i.hasNext()) {
                        this.locks.remove(i.next());
                    }
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scalar evaluate(String name, ScriptInstance script, Stack args) {
        String lname = BridgeUtilities.getString(args, "");
        if (name.equals("&lock")) {
            Scalar last = BridgeUtilities.getScalar(args);
            LockBridge lockBridge = this;
            synchronized (lockBridge) {
                this.locks.add(new LockMinion(lname, script, SleepUtils.isTrueScalar(last), (Stack)args.clone()));
            }
        } else {
            this.releaseLock(lname);
        }
        return SleepUtils.getEmptyScalar();
    }

    @Override
    public void scriptLoaded(ScriptInstance script) {
        script.getScriptEnvironment().getEnvironment().put("&lock", this);
        script.getScriptEnvironment().getEnvironment().put("&unlock", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance script) {
    }

    private class LockMinion {
        protected String name;
        protected ScriptInstance script;
        protected boolean keep;
        protected Stack args;

        public LockMinion(String name, ScriptInstance script, boolean keep, Stack args) {
            this.name = name;
            this.script = script;
            this.keep = keep;
            this.args = args;
        }

        public boolean grab() {
            if (LockBridge.this.acquireLock(this.name, this.script)) {
                LockBridge.this.events.fireEvent("locked_" + this.name, this.args, this.script);
                if (!this.keep) {
                    LockBridge.this.releaseLock(this.name);
                }
                return true;
            }
            return false;
        }
    }
}

