/*
 * Decompiled with CFR 0.152.
 */
package cortana.gui;

import armitage.ArmitageApplication;
import cortana.core.EventManager;
import cortana.gui.ScriptedMenu;
import cortana.gui.ScriptedMenuItem;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.SleepClosure;
import sleep.engine.Block;
import sleep.interfaces.Environment;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import ui.DynamicMenu;

public class MenuBridge
implements Loadable,
Function,
Environment {
    protected ArmitageApplication armitage;
    protected Stack parents = new Stack();
    protected Map menus = new HashMap();
    protected Stack data = new Stack();

    public Stack getArguments() {
        return (Stack)this.data.peek();
    }

    public MenuBridge(ArmitageApplication a) {
        this.armitage = a;
    }

    public void push(JComponent menu, Stack arguments) {
        this.parents.push(menu);
        this.data.push(arguments);
    }

    public void pop() {
        this.parents.pop();
        this.data.pop();
    }

    public JComponent getTopLevel() {
        if (this.parents.isEmpty()) {
            throw new RuntimeException("menu has no parent");
        }
        return (JComponent)this.parents.peek();
    }

    @Override
    public void bindFunction(ScriptInstance si, String name, String desc, Block body) {
        SleepClosure f = new SleepClosure(si, body);
        if (name.equals("menu")) {
            this.createMenu(desc, f);
        } else if (name.equals("item")) {
            this.createItem(desc, f);
        } else if (name.equals("popup")) {
            this.registerTopLevel(desc, f);
        }
    }

    public void registerTopLevel(String name, SleepClosure f) {
        if (!this.menus.containsKey(name)) {
            this.menus.put(name, new LinkedList());
        }
        LinkedList m = (LinkedList)this.menus.get(name);
        m.add(f);
    }

    public boolean isPopulated(String name) {
        return this.menus.containsKey(name) && ((LinkedList)this.menus.get(name)).size() > 0;
    }

    public LinkedList getMenus(String name) {
        if (this.menus.containsKey(name)) {
            return (LinkedList)this.menus.get(name);
        }
        return new LinkedList();
    }

    public void createMenu(String name, SleepClosure f) {
        JComponent top = this.getTopLevel();
        ScriptedMenu next = new ScriptedMenu(name, f, this);
        top.add(next);
    }

    public void createItem(String name, SleepClosure f) {
        JComponent top = this.getTopLevel();
        ScriptedMenuItem next = new ScriptedMenuItem(name, f, this);
        top.add(next);
    }

    @Override
    public Scalar evaluate(String name, ScriptInstance script, Stack args) {
        if (name.equals("&separator")) {
            if (this.getTopLevel() instanceof JMenu) {
                ((JMenu)this.getTopLevel()).addSeparator();
            } else if (this.getTopLevel() instanceof JPopupMenu) {
                ((JPopupMenu)this.getTopLevel()).addSeparator();
            }
        } else if (name.equals("&show_menu")) {
            String hook = BridgeUtilities.getString(args, "");
            if (args.size() > 0) {
                this.armitage.setupMenu(this.getTopLevel(), hook, EventManager.shallowCopy(args));
            } else {
                this.armitage.setupMenu(this.getTopLevel(), hook, this.getArguments());
            }
        } else if (name.equals("&show_popup")) {
            MouseEvent ev = (MouseEvent)BridgeUtilities.getObject(args);
            String hook = BridgeUtilities.getString(args, "");
            JPopupMenu popup = new JPopupMenu();
            this.push(popup, EventManager.shallowCopy(args));
            this.armitage.setupMenu(this.getTopLevel(), hook, this.getArguments());
            this.pop();
            popup.show((JComponent)ev.getSource(), ev.getX(), ev.getY());
        } else if (name.equals("&insert_menu")) {
            JMenu parent = (JMenu)BridgeUtilities.getObject(args);
            String hook = BridgeUtilities.getString(args, "");
            this.push(parent, EventManager.shallowCopy(args));
            this.armitage.setupMenu(this.getTopLevel(), hook, this.getArguments());
            this.pop();
        } else if (name.equals("&menubar")) {
            String _label = BridgeUtilities.getString(args, "");
            final String hook = BridgeUtilities.getString(args, "");
            int offset = BridgeUtilities.getInt(args, 2);
            DynamicMenu menu = new DynamicMenu("");
            if (_label.indexOf(38) > -1) {
                menu.setText(_label.substring(0, _label.indexOf(38)) + _label.substring(_label.indexOf(38) + 1, _label.length()));
                menu.setMnemonic(_label.charAt(_label.indexOf(38) + 1));
            } else {
                menu.setText(_label);
            }
            menu.setHandler(new DynamicMenu.DynamicMenuHandler(){

                @Override
                public void setupMenu(JMenu parent) {
                    MenuBridge.this.armitage.setupMenu(parent, hook, new Stack());
                    if (!MenuBridge.this.isPopulated(hook)) {
                        MenuBridge.this.armitage.getJMenuBar().remove(parent);
                        MenuBridge.this.armitage.getJMenuBar().validate();
                    }
                }
            });
            MenuElement[] menus = this.armitage.getJMenuBar().getSubElements();
            for (int x = 0; x < menus.length; ++x) {
                JMenu temp = (JMenu)menus[x].getComponent();
                if (!temp.getText().equals(menu.getText())) continue;
                this.armitage.getJMenuBar().remove(temp);
            }
            int index = this.armitage.getJMenuBar().getComponentCount() - offset;
            this.armitage.getJMenuBar().add((Component)menu, index >= 0 ? index : 0);
            this.armitage.getJMenuBar().validate();
        } else {
            String desc = BridgeUtilities.getString(args, "");
            SleepClosure f = BridgeUtilities.getFunction(args, script);
            if (name.equals("&menu")) {
                this.createMenu(desc, f);
            } else if (name.equals("&item")) {
                this.createItem(desc, f);
            } else if (name.equals("&popup")) {
                this.registerTopLevel(desc, f);
            }
        }
        return SleepUtils.getEmptyScalar();
    }

    @Override
    public void scriptLoaded(ScriptInstance si) {
        si.getScriptEnvironment().getEnvironment().put("popup", this);
        si.getScriptEnvironment().getEnvironment().put("&popup", this);
        si.getScriptEnvironment().getEnvironment().put("menu", this);
        si.getScriptEnvironment().getEnvironment().put("&menu", this);
        si.getScriptEnvironment().getEnvironment().put("item", this);
        si.getScriptEnvironment().getEnvironment().put("&item", this);
        si.getScriptEnvironment().getEnvironment().put("&separator", this);
        si.getScriptEnvironment().getEnvironment().put("&menubar", this);
        si.getScriptEnvironment().getEnvironment().put("&show_menu", this);
        si.getScriptEnvironment().getEnvironment().put("&insert_menu", this);
        si.getScriptEnvironment().getEnvironment().put("&show_popup", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance si) {
    }
}

