/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.Refreshable;
import graph.Route;
import java.awt.Image;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class RefreshGraph
implements Runnable {
    protected List nodes = new LinkedList();
    protected List highlights = new LinkedList();
    protected List routes = new LinkedList();
    protected Refreshable graph = null;

    public RefreshGraph(Refreshable graph) {
        this.graph = graph;
    }

    public void go() {
        SwingUtilities.invokeLater(this);
    }

    public void addRoute(Route route) {
        this.routes.add(route);
    }

    public void addNode(String id, String label, String description, Image iconz, String tooltip) {
        Node n = new Node();
        n.id = id;
        n.label = label;
        n.description = description;
        n.iconz = iconz;
        n.tooltip = tooltip;
        this.nodes.add(n);
    }

    public void addHighlight(String gateway, String host) {
        Highlight h = new Highlight();
        h.gateway = gateway;
        h.host = host;
        this.highlights.add(h);
    }

    @Override
    public void run() {
        this.graph.start();
        for (Node n : this.nodes) {
            this.graph.addNode(n.id, n.label, n.description, n.iconz, n.tooltip);
        }
        this.graph.setRoutes(this.routes.toArray(new Route[0]));
        for (Highlight h : this.highlights) {
            this.graph.highlightRoute(h.gateway, h.host);
        }
        this.graph.deleteNodes();
        this.graph.end();
    }

    private static class Node {
        public String id = "";
        public String label = "";
        public String description = "";
        public Image iconz = null;
        public String tooltip = "";

        private Node() {
        }
    }

    private static class Highlight {
        public String gateway = "";
        public String host = "";

        private Highlight() {
        }
    }
}

