/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.util.Iterator;
import sleep.engine.ObjectUtilities;
import sleep.runtime.Scalar;

public class ProxyIterator
implements Iterator {
    protected Iterator realIterator;
    protected boolean modifyAllow;

    public ProxyIterator(Iterator iterator, boolean bl) {
        this.realIterator = iterator;
        this.modifyAllow = bl;
    }

    public static boolean isIterator(Scalar scalar) {
        return scalar.getActualValue() != null && scalar.objectValue() instanceof Iterator;
    }

    public boolean hasNext() {
        return this.realIterator.hasNext();
    }

    public Object next() {
        Object e = this.realIterator.next();
        return ObjectUtilities.BuildScalar(true, e);
    }

    public void remove() {
        if (!this.modifyAllow) {
            throw new RuntimeException("iterator is read-only");
        }
        this.realIterator.remove();
    }
}

