/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SafeDialogs {
    public static void askYesNo(final String text, final String title, final SafeDialogCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int result = JOptionPane.showConfirmDialog(null, text, title, 0);
                if (result == 0 || result == 0) {
                    callback.result("yes");
                }
            }
        }).start();
    }

    public static void ask(final String text, final String initial, final SafeDialogCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String result = JOptionPane.showInputDialog(text, (Object)initial);
                callback.result(result);
            }
        }).start();
    }

    public static void saveFile(final JFrame frame, final String selection, final SafeDialogCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                File file;
                JFileChooser fc = new JFileChooser();
                if (selection != null) {
                    fc.setSelectedFile(new File(selection));
                }
                if (fc.showSaveDialog(frame) == 0 && (file = fc.getSelectedFile()) != null) {
                    callback.result(file + "");
                    return;
                }
            }
        }).start();
    }

    public static void openFile(final String title, final String sel, final String dir, final boolean multi, final boolean dirsonly, final SafeDialogCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JFileChooser fc = new JFileChooser();
                if (title != null) {
                    fc.setDialogTitle(title);
                }
                if (sel != null) {
                    fc.setSelectedFile(new File(sel));
                }
                if (dir != null) {
                    fc.setCurrentDirectory(new File(dir));
                }
                fc.setMultiSelectionEnabled(multi);
                if (dirsonly) {
                    fc.setFileSelectionMode(1);
                }
                if (fc.showOpenDialog(null) != 0) {
                    return;
                }
                if (multi) {
                    StringBuffer buffer = new StringBuffer();
                    File[] r = fc.getSelectedFiles();
                    for (int x = 0; x < r.length; ++x) {
                        if (r[x] == null || !r[x].exists()) continue;
                        buffer.append(r[x]);
                        if (x + 1 >= r.length) continue;
                        buffer.append(",");
                    }
                    callback.result(buffer.toString());
                } else if (fc.getSelectedFile() != null && fc.getSelectedFile().exists()) {
                    callback.result(fc.getSelectedFile() + "");
                }
            }
        }).start();
    }

    public static interface SafeDialogCallback {
        public void result(String var1);
    }
}

