/*
 * Decompiled with CFR 0.152.
 */
package msf;

import armitage.ArmitageMain;
import java.util.HashMap;
import java.util.LinkedList;
import msf.RpcCallback;
import msf.RpcConnection;

public class RpcQueue
implements Runnable {
    protected RpcConnection connection;
    protected LinkedList requests = new LinkedList();

    public RpcQueue(RpcConnection connection) {
        this.connection = connection;
        new Thread(this).start();
    }

    protected void processRequest(Request r) {
        block4: {
            try {
                Object result = this.connection.execute(r.method, r.args);
                if (r.callback != null) {
                    r.callback.result(result);
                }
            }
            catch (Exception ex) {
                ArmitageMain.print_error("RpcQueue Method '" + r.method + "' failed: " + ex.getMessage());
                for (int x = 0; x < r.args.length; ++x) {
                    System.err.println("\t" + x + ": " + r.args[x]);
                }
                ex.printStackTrace();
                if (r.callback == null) break block4;
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("error", ex.getMessage());
                r.callback.result(result);
            }
        }
    }

    public void execute(String method, Object[] args) {
        this.execute(method, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String method, Object[] args, RpcCallback callback) {
        RpcQueue rpcQueue = this;
        synchronized (rpcQueue) {
            Request temp = new Request();
            temp.method = method;
            temp.args = args == null ? new Object[0] : args;
            temp.callback = callback;
            this.requests.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request grabRequest() {
        RpcQueue rpcQueue = this;
        synchronized (rpcQueue) {
            return (Request)this.requests.pollFirst();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                Request next;
                if ((next = this.grabRequest()) != null) {
                    this.processRequest(next);
                    Thread.yield();
                    continue;
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    private static class Request {
        public String method;
        public Object[] args;
        public RpcCallback callback = null;

        private Request() {
        }
    }
}

