/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventObject;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import table.GenericTableModel;
import ui.CutCopyPastePopup;

public class ATable
extends JTable {
    public static final String indicator = " \u271a";
    protected boolean alternateBackground = false;
    protected int[] selected = null;

    public void markSelections() {
        this.selected = this.getSelectedRows();
    }

    public void fixSelection() {
        if (this.selected.length == 0) {
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        int rowcount = this.getModel().getRowCount();
        for (int x = 0; x < this.selected.length; ++x) {
            if (this.selected[x] >= rowcount) continue;
            this.getSelectionModel().addSelectionInterval(this.selected[x], this.selected[x]);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
    }

    public void restoreSelections() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ATable.this.fixSelection();
                }
            });
        } else {
            this.fixSelection();
        }
    }

    public static TableCellRenderer getDefaultTableRenderer(JTable table, final TableModel model) {
        final HashSet<String> specialitems = new HashSet<String>();
        specialitems.add("Wordlist");
        specialitems.add("PAYLOAD");
        specialitems.add("RHOST");
        specialitems.add("RHOSTS");
        specialitems.add("Template");
        specialitems.add("DICTIONARY");
        specialitems.add("NAMELIST");
        specialitems.add("SigningKey");
        specialitems.add("SigningCert");
        specialitems.add("WORDLIST");
        specialitems.add("SESSION");
        specialitems.add("REXE");
        specialitems.add("EXE::Custom");
        specialitems.add("EXE::Template");
        specialitems.add("USERNAME");
        specialitems.add("PASSWORD");
        specialitems.add("SMBUser");
        specialitems.add("SMBPass");
        specialitems.add("PATH");
        specialitems.add("SCRIPT");
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TableCellRenderer render = table.getDefaultRenderer(String.class);
                String content = (value != null ? value : "") + "";
                if (specialitems.contains(content) || content.indexOf("FILE") != -1) {
                    content = content + ATable.indicator;
                }
                JComponent c = (JComponent)render.getTableCellRendererComponent(table, content, isSelected, false, row, column);
                c.setToolTipText(((GenericTableModel)model).getValueAtColumn(table, row, "Tooltip") + "");
                return c;
            }
        };
    }

    public static TableCellRenderer getFileTypeTableRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TableCellRenderer render = table.getDefaultRenderer(String.class);
                JComponent c = (JComponent)render.getTableCellRendererComponent(table, "", isSelected, false, row, column);
                if ("dir".equals(value)) {
                    FileSystemView view = FileSystemView.getFileSystemView();
                    Icon chooser = view.getSystemIcon(view.getDefaultDirectory());
                    ((JLabel)c).setIcon(chooser);
                } else {
                    ((JLabel)c).setIcon(null);
                }
                return c;
            }
        };
    }

    public static TableCellRenderer getSimpleTableRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TableCellRenderer render = table.getDefaultRenderer(String.class);
                JComponent c = (JComponent)render.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                ((JLabel)c).setIcon(null);
                return c;
            }
        };
    }

    public static TableCellRenderer getSizeTableRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TableCellRenderer render = table.getDefaultRenderer(String.class);
                JComponent c = (JComponent)render.getTableCellRendererComponent(table, "", isSelected, false, row, column);
                try {
                    long size = Long.parseLong(value + "");
                    String units = "b";
                    if (size > 1024L) {
                        size /= 1024L;
                        units = "kb";
                    }
                    if (size > 1024L) {
                        size /= 1024L;
                        units = "mb";
                    }
                    if (size > 1024L) {
                        size /= 1024L;
                        units = "gb";
                    }
                    ((JLabel)c).setText(size + units);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return c;
            }
        };
    }

    public static TableCellRenderer getTimeTableRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TableCellRenderer render = table.getDefaultRenderer(String.class);
                JComponent c = (JComponent)render.getTableCellRendererComponent(table, "", isSelected, false, row, column);
                try {
                    long size = Long.parseLong(value + "");
                    String units = "ms";
                    if (size <= 1000L) {
                        ((JLabel)c).setText(size + units);
                        return c;
                    }
                    units = "s";
                    if ((size /= 1000L) > 60L) {
                        size /= 60L;
                        units = "m";
                    }
                    if (size > 60L) {
                        size /= 60L;
                        units = "h";
                    }
                    ((JLabel)c).setText(size + units);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return c;
            }
        };
    }

    public void adjust() {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(this.getRowHeight() + 2);
        final TableCellEditor defaulte = this.getDefaultEditor(Object.class);
        this.setDefaultEditor(Object.class, new TableCellEditor(){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int col) {
                Component editor = defaulte.getTableCellEditorComponent(table, value, selected, row, col);
                if (editor instanceof JTextComponent) {
                    new CutCopyPastePopup((JTextComponent)editor);
                }
                return editor;
            }

            @Override
            public void addCellEditorListener(CellEditorListener l) {
                defaulte.addCellEditorListener(l);
            }

            @Override
            public void cancelCellEditing() {
                defaulte.cancelCellEditing();
            }

            @Override
            public Object getCellEditorValue() {
                return defaulte.getCellEditorValue();
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return defaulte.isCellEditable(anEvent);
            }

            @Override
            public void removeCellEditorListener(CellEditorListener l) {
                defaulte.removeCellEditorListener(l);
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return defaulte.shouldSelectCell(anEvent);
            }

            @Override
            public boolean stopCellEditing() {
                return defaulte.stopCellEditing();
            }
        });
        final TableCellRenderer defaultr = this.getDefaultRenderer(Object.class);
        this.setDefaultRenderer(Object.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null) {
                    value = "";
                }
                return defaultr.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }
        });
    }

    public ATable() {
        this.adjust();
    }

    public ATable(TableModel model) {
        super(model);
        this.adjust();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        this.alternateBackground = row % 2 == 0;
        Component component = super.prepareRenderer(renderer, row, column);
        if (!Color.WHITE.equals(component.getForeground())) {
            ((JComponent)component).setOpaque(true);
            component.setBackground(this.getComponentBackground());
        }
        return component;
    }

    public Color getComponentBackground() {
        return this.alternateBackground ? new Color(0xF2F2F2) : Color.WHITE;
    }
}

