/*
 * Decompiled with CFR 0.152.
 */
package armitage;

import armitage.ArmitageMain;
import armitage.ConsoleClient;
import console.Console;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import msf.RpcConnection;

public class ConsoleQueue
implements Runnable {
    protected RpcConnection connection;
    protected LinkedList listeners = new LinkedList();
    protected LinkedList listeners_all = new LinkedList();
    protected LinkedList commands = new LinkedList();
    protected String consoleid = null;
    protected Console display = null;
    protected boolean stop = false;
    private String destroyCommand = "console.release";

    public Console getWindow() {
        return this.display;
    }

    public List tabComplete(String pcommand) {
        try {
            Map read2 = (Map)this.connection.execute("console.tabs", new Object[]{this.consoleid, pcommand});
            if (read2.containsKey("tabs")) {
                return (List)read2.get("tabs");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new LinkedList();
    }

    public void addListener(ConsoleCallback l) {
        this.listeners.add(l);
    }

    public void addSessionListener(ConsoleCallback l) {
        this.listeners_all.add(l);
    }

    public void setDisplay(final Console display) {
        this.display = display;
        display.getInput().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                display.getInput().setText("");
                ConsoleQueue.this.addCommand(null, ev.getActionCommand());
            }
        });
    }

    public void fireSessionReadEvent(String text) {
        Iterator i = this.listeners_all.iterator();
        while (i.hasNext()) {
            ((ConsoleCallback)i.next()).commandComplete(this, null, text);
        }
    }

    public void fireEvent(Command command, String output) {
        if (command.token == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ConsoleCallback)i.next()).commandComplete(this, command != null ? command.token : null, output);
        }
    }

    public ConsoleQueue(RpcConnection connection) {
        this.connection = connection;
    }

    public boolean isEmptyData(String data) {
        return "".equals(data) || "null".equals(data);
    }

    protected void processCommand(Command c) {
        if (c.assign == null) {
            this.processNormalCommand(c);
        } else {
            this.processAssignCommand(c);
        }
    }

    protected void priority(String key, Map options, Set expected, StringBuffer writeme) {
        if (!options.containsKey(key)) {
            return;
        }
        String value = options.get(key) + "";
        writeme.append("set " + key + " " + value + "\n");
        expected.add(key);
        options.remove(key);
    }

    protected void processAssignCommand(Command c) {
        try {
            Map read2 = this.readResponse();
            String prompt = ConsoleClient.cleanText(read2.get("prompt") + "");
            StringBuffer writeme = new StringBuffer();
            HashSet<String> expected = new HashSet<String>();
            this.priority("TARGET", c.assign, expected, writeme);
            this.priority("PAYLOAD", c.assign, expected, writeme);
            this.priority("LHOST", c.assign, expected, writeme);
            this.priority("LPORT", c.assign, expected, writeme);
            for (Map.Entry entry : c.assign.entrySet()) {
                String key = entry.getKey() + "";
                String value = entry.getValue() + "";
                writeme.append("set " + key + " " + value + "\n");
                expected.add(key);
            }
            this.connection.execute("console.write", new Object[]{this.consoleid, writeme.toString()});
            long start = System.currentTimeMillis();
            while (expected.size() > 0) {
                Thread.yield();
                Map temp = (Map)this.connection.execute("console.read", new Object[]{this.consoleid});
                if (!this.isEmptyData(temp.get("data") + "")) {
                    String[] lines = (temp.get("data") + "").split("\n");
                    for (int x = 0; x < lines.length; ++x) {
                        if (lines[x].indexOf(" => ") != -1) {
                            String[] kv = lines[x].split(" => ");
                            expected.remove(kv[0]);
                            if (this.display == null) continue;
                            if (kv.length == 2) {
                                this.display.append(prompt + "set " + kv[0] + " " + kv[1] + "\n");
                            } else {
                                this.display.append(prompt + "set " + kv[0] + "\n");
                            }
                            this.display.append(lines[x] + "\n");
                            continue;
                        }
                        if (this.display != null) {
                            this.display.append(lines[x] + "\n");
                            continue;
                        }
                        ArmitageMain.print_error("Batch read unexpected: " + lines[x]);
                    }
                    continue;
                }
                if (System.currentTimeMillis() - start <= 10000L) continue;
                ArmitageMain.print_error("Console Command Timed out: '" + c.assign + "' wanted: " + expected);
                break;
            }
        }
        catch (Exception ex) {
            ArmitageMain.print_error("Console " + this.consoleid + " Exception '" + c.text + "': " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected void processNormalCommand(Command c) {
        Map read2 = null;
        try {
            if (c.text.startsWith("ECHO ")) {
                if (this.display != null) {
                    this.display.append(c.text.substring(5));
                }
                return;
            }
            StringBuffer writeme = new StringBuffer();
            writeme.append(c.text);
            writeme.append("\n");
            read2 = this.readResponse();
            String prompt = ConsoleClient.cleanText(read2.get("prompt") + "");
            if (this.display != null) {
                this.display.append(prompt + writeme.toString());
            }
            this.connection.execute("console.write", new Object[]{this.consoleid, writeme.toString()});
            StringBuffer output = new StringBuffer();
            Thread.sleep(10L);
            int count = 0;
            long start = System.currentTimeMillis();
            while ((read2 = this.readResponse()) != null) {
                String text = null;
                if (!this.isEmptyData(read2.get("data") + "")) {
                    text = read2.get("data") + "";
                    output.append(text);
                    ++count;
                } else if ("false".equals(read2.get("busy") + "") && this.isEmptyData(read2.get("data") + "")) {
                    if (count > 0) break;
                    if (System.currentTimeMillis() - start > 10000L) {
                        ArmitageMain.print_error("Timed out while executing '" + c.text + "' last read = " + read2 + "; current prompt = '" + prompt + "'");
                        break;
                    }
                } else if ("failure".equals(read2.get("result") + "")) break;
                if (!prompt.equals(ConsoleClient.cleanText(read2.get("prompt") + ""))) {
                    ++count;
                }
                Thread.sleep(10L);
            }
            this.fireEvent(c, output.toString());
        }
        catch (Exception ex) {
            ArmitageMain.print_error("Exception when executing '" + c.text + "' in console " + this.consoleid + ": " + ex.getMessage() + "\n\tlast read: " + read2);
            ex.printStackTrace();
        }
    }

    public void append(String text) {
        this.addCommand(null, "ECHO " + text + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptions(Map options) {
        ConsoleQueue consoleQueue = this;
        synchronized (consoleQueue) {
            Command temp = new Command();
            temp.token = null;
            temp.text = null;
            temp.assign = options;
            this.commands.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Object token, String text) {
        ConsoleQueue consoleQueue = this;
        synchronized (consoleQueue) {
            if (text.trim().equals("")) {
                return;
            }
            Command temp = new Command();
            temp.token = token;
            temp.text = text;
            this.commands.add(temp);
        }
    }

    public void start() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ConsoleQueue consoleQueue = this;
        synchronized (consoleQueue) {
            this.stop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ConsoleQueue consoleQueue = this;
        synchronized (consoleQueue) {
            this.destroyCommand = "console.release_and_destroy";
            this.stop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Command grabCommand() {
        ConsoleQueue consoleQueue = this;
        synchronized (consoleQueue) {
            return (Command)this.commands.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Map read2 = (Map)this.connection.execute("console.allocate", new Object[0]);
            this.consoleid = read2.get("id") + "";
            while (true) {
                Command next;
                if ((next = this.grabCommand()) != null) {
                    this.processCommand(next);
                    Thread.sleep(10L);
                    continue;
                }
                ConsoleQueue consoleQueue = this;
                synchronized (consoleQueue) {
                    if (this.stop) {
                        break;
                    }
                }
                if (this.display != null) {
                    this.readResponse();
                }
                Thread.sleep(1000L);
            }
            this.connection.execute(this.destroyCommand, new Object[]{this.consoleid});
        }
        catch (Exception ex) {
            ArmitageMain.print_error("console " + this.consoleid + " is dead: " + ex.getMessage());
            return;
        }
    }

    private Map readResponse() throws Exception {
        String prompt;
        Thread.yield();
        Map temp = (Map)this.connection.execute("console.read", new Object[]{this.consoleid});
        if (this.display != null && !this.isEmptyData(temp.get("data") + "")) {
            this.display.append(temp.get("data") + "");
            this.fireSessionReadEvent(temp.get("data") + "");
        }
        if (this.display != null && !this.isEmptyData(temp.get("prompt") + "") && !"meterpreter > ".equals(prompt = ConsoleClient.cleanText(temp.get("prompt") + ""))) {
            this.display.updatePrompt(prompt);
        }
        return temp;
    }

    public static interface ConsoleCallback {
        public void commandComplete(ConsoleQueue var1, Object var2, String var3);
    }

    private static class Command {
        public Object token = null;
        public String text = null;
        public Map assign = null;
        public long start = System.currentTimeMillis();

        private Command() {
        }
    }
}

