/*
 * Decompiled with CFR 0.152.
 */
package armitage;

import console.Console;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public abstract class GenericTabCompletion {
    protected Console window;
    protected String last = null;
    protected Iterator tabs = null;

    public Console getWindow() {
        return this.window;
    }

    public GenericTabCompletion(Console windowz) {
        this.window = windowz;
        this.window.addActionForKey("pressed TAB", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                GenericTabCompletion.this.tabComplete(ev);
            }
        });
    }

    public abstract Collection getOptions(String var1);

    public String transformText(String text) {
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tabCompleteFirst(String text) {
        try {
            text = this.transformText(text);
            LinkedHashSet<String> responses = new LinkedHashSet<String>();
            Collection options = this.getOptions(text);
            if (options == null) {
                return;
            }
            Iterator i = options.iterator();
            while (i.hasNext()) {
                String end;
                String begin;
                String option = i.next() + "";
                if (text.length() > option.length()) {
                    begin = option;
                    end = "";
                } else {
                    begin = option.substring(0, text.length());
                    end = option.substring(text.length());
                }
                int nextSlash = end.indexOf(47);
                if (nextSlash > -1 && nextSlash + 1 < end.length()) {
                    end = end.substring(0, nextSlash);
                }
                responses.add(begin + end);
            }
            responses.add(text);
            Console console = this.window;
            synchronized (console) {
                this.tabs = responses.iterator();
                this.last = (String)this.tabs.next();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenericTabCompletion.this.window.getInput().setText(GenericTabCompletion.this.last);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tabComplete(ActionEvent ev) {
        final String text = this.window.getInput().getText();
        if (text.length() == 0) {
            return;
        }
        Console console = this.window;
        synchronized (console) {
            if (this.tabs != null && this.tabs.hasNext() && text.equals(this.last)) {
                this.last = (String)this.tabs.next();
                this.window.getInput().setText(this.last);
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    GenericTabCompletion.this.tabCompleteFirst(text);
                }
            }).start();
        }
    }
}

