/*
 * Decompiled with CFR 0.152.
 */
package cortana;

import armitage.ArmitageApplication;
import armitage.ConsoleClient;
import console.Console;
import cortana.CortanaPipe;
import cortana.Loader;
import cortana.core.CommandManager;
import cortana.core.EventManager;
import cortana.core.FilterManager;
import cortana.data.DataManager;
import cortana.gui.KeyBridge;
import cortana.gui.MenuBuilder;
import cortana.gui.UIBridge;
import cortana.metasploit.ConsoleBridge;
import cortana.metasploit.EventLogBridge;
import cortana.metasploit.MetasploitBridge;
import cortana.metasploit.MeterpreterBridge;
import cortana.metasploit.ShellBridge;
import cortana.support.CortanaUtilities;
import cortana.support.Heartbeat;
import cortana.support.LockBridge;
import cortana.support.Shared;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import msf.MeterpreterSession;
import msf.RpcConnection;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.io.IOObject;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class Cortana
implements Loadable,
RuntimeWarningWatcher,
Function {
    public static final int DEBUG_INTERACT_LOG = 256;
    public static final int DEBUG_INTERACT_ASK = 512;
    protected RpcConnection client;
    protected RpcConnection dserver;
    protected ArmitageApplication application = null;
    protected Properties preferences = null;
    protected Shared shared = null;
    protected String describe = "default";
    protected int version = 0;
    protected EventManager events;
    protected FilterManager filters;
    protected CommandManager commands;
    protected DataManager data;
    protected MetasploitBridge metasploit;
    protected MeterpreterBridge meterpreter;
    protected ShellBridge shell;
    protected ConsoleBridge console;
    protected Loadable log = null;
    protected Loadable locks = null;
    protected Loadable keys = null;
    protected Loadable menus = null;
    protected Loadable ui = null;
    protected Loadable utils = null;
    protected IOObject cortana_io = null;
    protected CortanaPipe pipe = null;
    protected Object internal = null;
    protected Object internal_gui = null;
    protected Object internal_gui2 = null;
    protected boolean started = false;
    protected Map scripts = new HashMap();

    @Override
    public void scriptLoaded(ScriptInstance si) {
        if (this.cortana_io != null) {
            IOObject.setConsole(si.getScriptEnvironment(), this.cortana_io);
        }
        si.getScriptEnvironment().getEnvironment().put("&script_load", this);
        si.getScriptEnvironment().getEnvironment().put("&script_unload", this);
    }

    public void setupArmitage(ArmitageApplication application, Properties preferences) {
        this.keys = new KeyBridge(application);
        MenuBuilder builder = new MenuBuilder(application);
        application.setMenuBuilder(builder);
        this.menus = builder.getBridge();
        this.ui = new UIBridge(application);
        this.application = application;
        this.preferences = preferences;
        this.shared = new Shared();
    }

    @Override
    public void scriptUnloaded(ScriptInstance si) {
    }

    public Shared getSharedData() {
        return this.shared;
    }

    @Override
    public Scalar evaluate(String function2, ScriptInstance script, Stack args) {
        if (function2.equals("&script_load")) {
            try {
                this.loadScript(BridgeUtilities.getString(args, ""));
            }
            catch (YourCodeSucksException yex) {
                throw new RuntimeException(yex.formatErrors());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else if (function2.equals("&script_unload")) {
            String scriptf = this.findScript(BridgeUtilities.getString(args, ""));
            if (scriptf == null) {
                throw new RuntimeException("Could not find script");
            }
            this.unloadScript(scriptf);
        }
        return SleepUtils.getEmptyScalar();
    }

    public Cortana(RpcConnection client, RpcConnection dserver, EventManager events, FilterManager filters, String description, int msfversion) {
        this.client = client;
        this.dserver = dserver;
        this.events = events;
        this.filters = filters;
        this.describe = description;
        this.version = msfversion;
        this.metasploit = new MetasploitBridge(client, dserver, events, filters);
        this.meterpreter = new MeterpreterBridge(client, dserver, events, filters);
        this.shell = new ShellBridge(client, dserver, events, filters);
        this.console = new ConsoleBridge(client, events, filters);
        this.log = new EventLogBridge(client, dserver, events, filters);
        this.locks = new LockBridge(dserver, events);
        this.data = new DataManager(dserver, events, client != dserver);
        this.utils = new CortanaUtilities(this.metasploit);
        this.commands = new CommandManager();
    }

    public void setupCallbackIO() {
        this.pipe = new CortanaPipe();
        this.cortana_io = new IOObject();
        this.cortana_io.openWrite(this.pipe.getOutput());
        ++this.metasploit.loadedScripts;
    }

    public void addTextListener(CortanaPipe.CortanaPipeListener l) {
        this.pipe.addCortanaPipeListener(l);
    }

    private void p(String text) {
        if (this.cortana_io != null) {
            this.cortana_io.printLine(text);
        } else {
            System.out.println(text);
        }
    }

    @Override
    public void processScriptWarning(ScriptWarning warning) {
        String from = warning.getNameShort() + ":" + warning.getLineNumber();
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        Date adate = new Date();
        String niced = format.format(adate, new StringBuffer(), new FieldPosition(0)).toString();
        if (warning.isDebugTrace()) {
            this.p("[" + niced + "] Trace: " + warning.getMessage() + " at " + from);
        } else {
            this.p("[" + niced + "] " + warning.getMessage() + " at " + from);
        }
    }

    public void filterList(List l, String filter) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            String cmd = i.next() + "";
            if (cmd.startsWith(filter)) continue;
            i.remove();
        }
    }

    public String findScript(String script) {
        Iterator i = this.scripts.keySet().iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            File s = new File(name);
            if (!script.equals(s.getName())) continue;
            return name;
        }
        return null;
    }

    public List commandList(String filter) {
        String[] data = filter.trim().split("\\s+");
        if ("askon".equals(data[0]) || "askoff".equals(data[0]) || "logon".equals(data[0]) || "logoff".equals(data[0]) || "reload".equals(data[0]) || "pron".equals(data[0]) || "profile".equals(data[0]) || "proff".equals(data[0]) || "tron".equals(data[0]) || "unload".equals(data[0]) || "troff".equals(data[0])) {
            LinkedList<String> res = new LinkedList<String>();
            Iterator i = this.scripts.keySet().iterator();
            while (i.hasNext()) {
                res.add(data[0] + " " + new File(i.next() + "").getName());
            }
            this.filterList(res, filter);
            Collections.sort(res);
            return res;
        }
        if ("load".equals(data[0]) && filter.length() > 5) {
            String file = filter.substring(5);
            File temp = new File(file);
            if (!temp.exists() || !temp.isDirectory()) {
                temp = temp.getParentFile();
            }
            LinkedList<String> res = new LinkedList<String>();
            if (temp == null) {
                res.add(filter);
                return res;
            }
            File[] s = temp.listFiles();
            for (int x = 0; s != null && x < s.length; ++x) {
                if (!s[x].isDirectory() && !s[x].getName().endsWith(".cna")) continue;
                res.add(data[0] + " " + s[x].getAbsolutePath());
            }
            this.filterList(res, filter);
            Collections.sort(res);
            return res;
        }
        List cmdl = this.commands.commandList(filter);
        cmdl.add("askon");
        cmdl.add("askoff");
        cmdl.add("help");
        cmdl.add("ls");
        cmdl.add("reload");
        cmdl.add("unload");
        cmdl.add("load");
        cmdl.add("logon");
        cmdl.add("logoff");
        cmdl.add("pron");
        cmdl.add("proff");
        cmdl.add("profile");
        cmdl.add("tron");
        cmdl.add("troff");
        Collections.sort(cmdl);
        this.filterList(cmdl, filter);
        return cmdl;
    }

    public void processCommand(String text) {
        String[] data = text.trim().split("\\s+");
        HashSet<String> states = new HashSet<String>();
        states.add("tron");
        states.add("troff");
        states.add("profile");
        states.add("pron");
        states.add("proff");
        states.add("logon");
        states.add("logoff");
        states.add("askon");
        states.add("askoff");
        HashSet<String> cmds = new HashSet<String>();
        cmds.addAll(states);
        cmds.add("unload");
        cmds.add("load");
        cmds.add("reload");
        if ("ls".equals(text)) {
            this.p("");
            this.p("Scripts");
            this.p("-------");
            for (String temp : this.scripts.keySet()) {
                if (temp == null) continue;
                File script = new File(temp);
                this.p(script.getName());
            }
            this.p("");
        } else if (cmds.contains(data[0]) && data.length != 2) {
            this.p("[-] Missing arguments");
        } else if (states.contains(data[0]) && data.length == 2) {
            String script = this.findScript(data[1]);
            if (script == null) {
                this.p("[-] Could not find '" + data[1] + "'");
            } else {
                Loader loader = (Loader)this.scripts.get(script);
                if ("askon".equals(data[0])) {
                    this.p("[+] Prompting actions for '" + data[1] + "'");
                    loader.setDebugLevel(512);
                } else if ("askoff".equals(data[0])) {
                    this.p("[+] Stopped prompts from '" + data[1] + "'");
                    loader.unsetDebugLevel(512);
                } else if ("logon".equals(data[0])) {
                    this.p("[+] Logging '" + data[1] + "'");
                    loader.setDebugLevel(256);
                } else if ("logoff".equals(data[0])) {
                    this.p("[+] Stopped log of '" + data[1] + "'");
                    loader.unsetDebugLevel(256);
                } else if ("tron".equals(data[0])) {
                    this.p("[+] Tracing '" + data[1] + "'");
                    loader.setDebugLevel(8);
                } else if ("troff".equals(data[0])) {
                    this.p("[+] Stopped trace of '" + data[1] + "'");
                    loader.unsetDebugLevel(8);
                } else if ("pron".equals(data[0])) {
                    this.p("[+] Profiling '" + data[1] + "'");
                    loader.setDebugLevel(24);
                } else if ("profile".equals(data[0]) || "proff".equals(data[0])) {
                    if ("proff".equals(data[0])) {
                        this.p("[+] Stopped profile of '" + data[1] + "'");
                        loader.unsetDebugLevel(24);
                    }
                    this.p("");
                    this.p("Profile " + data[1]);
                    this.p("-------");
                    loader.printProfile(this.cortana_io == null ? System.out : this.cortana_io.getOutputStream());
                    this.p("");
                }
            }
        } else if ("unload".equals(data[0]) && data.length == 2) {
            String script = this.findScript(data[1]);
            if (script == null) {
                this.p("[-] Could not find '" + data[1] + "'");
            } else {
                this.p("[+] Unload " + script);
                this.unloadScript(script);
            }
        } else if ("load".equals(data[0]) && data.length == 2) {
            this.p("[+] Load " + data[1]);
            try {
                this.loadScript(data[1]);
            }
            catch (YourCodeSucksException yex) {
                this.p(yex.formatErrors());
            }
            catch (Exception ex) {
                this.p("[-] Could not load: " + ex.getMessage());
            }
        } else if ("reload".equals(data[0]) && data.length == 2) {
            String script = this.findScript(data[1]);
            if (script == null) {
                this.p("[-] Could not find '" + data[1] + "'");
            } else {
                this.p("[+] Reload " + script);
                try {
                    this.unloadScript(script);
                    this.loadScript(script);
                }
                catch (IOException ioex) {
                    this.p("[-] Could not load: '" + data[1] + "' " + ioex.getMessage());
                }
                catch (YourCodeSucksException yex) {
                    this.p(yex.formatErrors());
                }
            }
        } else if ("help".equals(text)) {
            this.p("");
            this.p("Commands");
            this.p("--------");
            Iterator i = this.commandList("").iterator();
            while (i.hasNext()) {
                this.p(i.next() + "");
            }
            this.p("");
        } else if (!this.commands.fireCommand(data[0], text)) {
            this.p("[-] Command not found");
        }
    }

    public ConsoleClient getEventLog(Console window) {
        return ((EventLogBridge)this.log).start(window);
    }

    public MeterpreterSession getSession(String sid) {
        return this.meterpreter.getSession(sid);
    }

    public void updateLocalHost(String lhost) {
        this.metasploit.setLocalHost(lhost);
    }

    public void start(String lhost) {
        if (!this.started) {
            this.metasploit.setLocalHost(lhost);
            this.data.start();
            new Heartbeat(this.events).start();
        }
        this.started = true;
    }

    public void unloadScript(String file) {
        Loader loader = (Loader)this.scripts.get(file);
        if (loader == null) {
            return;
        }
        this.scripts.remove(file);
        loader.unload();
    }

    public void loadScript(String file) throws YourCodeSucksException, IOException {
        Loader loader = new Loader(this);
        if (this.scripts.containsKey(file)) {
            throw new RuntimeException(file + " is already loaded");
        }
        loader.getScriptLoader().addGlobalBridge(this.events.getBridge());
        loader.getScriptLoader().addGlobalBridge(this.filters.getBridge());
        loader.getScriptLoader().addGlobalBridge(this.commands.getBridge());
        loader.getScriptLoader().addGlobalBridge(this.data);
        loader.getScriptLoader().addGlobalBridge(this.metasploit);
        loader.getScriptLoader().addGlobalBridge(this.meterpreter);
        loader.getScriptLoader().addGlobalBridge(this.shell);
        loader.getScriptLoader().addGlobalBridge(this.console);
        loader.getScriptLoader().addGlobalBridge(this.locks);
        loader.getScriptLoader().addGlobalBridge(this.log);
        loader.getScriptLoader().addGlobalBridge(this.utils);
        loader.getScriptLoader().addGlobalBridge(this);
        if (this.keys != null) {
            loader.getScriptLoader().addGlobalBridge(this.keys);
        }
        if (this.menus != null) {
            loader.getScriptLoader().addGlobalBridge(this.menus);
        }
        if (this.ui != null) {
            loader.getScriptLoader().addGlobalBridge(this.ui);
        }
        if (this.shared != null) {
            loader.getScriptLoader().addGlobalBridge(this.shared);
        }
        loader.setGlobal("$client", SleepUtils.getScalar(this.client));
        loader.setGlobal("$mclient", SleepUtils.getScalar(this.dserver));
        loader.setGlobal("$__describe__", SleepUtils.getScalar(this.describe));
        loader.setGlobal("$__msfversion__", SleepUtils.getScalar(this.version));
        this.internal = loader.loadInternalScript("scripts-cortana/internal.sl", this.internal);
        if (this.keys != null || this.menus != null) {
            loader.setGlobal("$armitage", SleepUtils.getScalar(this.application));
            loader.setGlobal("$preferences", SleepUtils.getScalar(this.preferences));
            loader.setGlobal("$shared", SleepUtils.getScalar(this.shared));
            this.internal_gui = loader.loadInternalScript("scripts-cortana/internal-ui.sl", this.internal_gui);
            this.internal_gui2 = loader.loadInternalScript("scripts-cortana/internal-ui-support.sl", this.internal_gui2);
        }
        final ScriptInstance script = loader.loadScript(file);
        this.scripts.put(file, loader);
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (Cortana.this.data.isReady()) {
                    Cortana.this.events.fireEvent("ready", new Stack(), script);
                }
            }
        }).start();
    }

    public Cortana(RpcConnection client, RpcConnection dserver, String[] scripts, String lhost, int version) {
        this(client, dserver, new EventManager(), new FilterManager(), "default", version);
        for (int x = 0; x < scripts.length; ++x) {
            try {
                this.loadScript(scripts[x]);
                continue;
            }
            catch (YourCodeSucksException yex) {
                System.err.println("Syntax errors in: " + scripts[x]);
                yex.printErrors(System.out);
                continue;
            }
            catch (IOException ioex) {
                System.err.println("Could not load: " + scripts[x] + " " + ioex.getMessage());
                ioex.printStackTrace();
            }
        }
        ((EventLogBridge)this.log).start(null);
        this.start(lhost);
    }
}

