/*
 * Decompiled with CFR 0.152.
 */
package cortana.data;

import cortana.core.EventManager;
import cortana.core.FilterManager;
import cortana.data.Credential;
import cortana.data.DataUtils;
import cortana.data.ManagedData;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import msf.RpcConnection;
import sleep.runtime.Scalar;

public class Credentials
extends ManagedData {
    protected RpcConnection client;
    protected EventManager manager;
    protected List creds = new LinkedList();

    public Credentials(RpcConnection client, EventManager manager) {
        this.client = client;
        this.manager = manager;
    }

    public List getCredentials() {
        return this.creds;
    }

    @Override
    public Scalar getScalar() {
        if (this.cache == null) {
            this.cache = FilterManager.convertAll(this.getCredentials());
        }
        return this.cache;
    }

    protected void fireCredentialEvent(String event, Iterator crds) {
        if (this.isInitial()) {
            return;
        }
        while (crds.hasNext()) {
            Credential t = (Credential)crds.next();
            this.manager.fireEventAsync(event, t.arguments());
        }
    }

    protected Set toSet(List results) {
        HashSet<Credential> temp = new HashSet<Credential>();
        for (Map data : results) {
            String host = data.get("host") + "";
            String port = data.get("port") + "";
            String user = data.get("user") + "";
            String pass = data.get("pass") + "";
            String type = data.get("ptype") + "";
            temp.add(new Credential(host, port, user, pass, type));
        }
        return temp;
    }

    public void processCreds(Map results) {
        if (!results.containsKey("creds")) {
            return;
        }
        this.cache = null;
        Set oldCredentials = this.toSet(this.creds);
        this.creds = (List)results.get("creds");
        Set newCredentials = this.toSet(this.creds);
        if (!this.initial) {
            Set newStuff = DataUtils.difference(newCredentials, oldCredentials);
            this.fireCredentialEvent("credential_add", newStuff.iterator());
            Set deletedStuff = DataUtils.difference(oldCredentials, newCredentials);
            this.fireCredentialEvent("credential_delete", deletedStuff.iterator());
        }
        Stack<Scalar> args = new Stack<Scalar>();
        args.push(FilterManager.convertAll(this.creds));
        this.manager.fireEventAsync("credentials", args);
        this.initial = false;
    }
}

