/*
 * Decompiled with CFR 0.152.
 */
package cortana.data;

import cortana.core.EventManager;
import cortana.core.FilterManager;
import cortana.data.DataUtils;
import cortana.data.ManagedData;
import graph.Route;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import msf.RpcConnection;
import sleep.runtime.Scalar;

public class Routes
extends ManagedData {
    protected RpcConnection client;
    protected EventManager manager;
    protected List routes = new LinkedList();

    public List getRoutes() {
        return this.routes;
    }

    @Override
    public Scalar getScalar() {
        if (this.cache == null) {
            this.cache = FilterManager.convertAll(this.getRoutes());
        }
        return this.cache;
    }

    public Routes(RpcConnection client, EventManager manager) {
        this.client = client;
        this.manager = manager;
    }

    protected void fireRouteEvents(String name, Iterator routes) {
        if (this.initial) {
            return;
        }
        while (routes.hasNext()) {
            Route temp = (Route)routes.next();
            Stack<Scalar> arg = new Stack<Scalar>();
            arg.push(FilterManager.convertAll(temp));
            this.manager.fireEventAsync(name, arg);
        }
    }

    public void processRoutes(Map results) {
        this.cache = null;
        HashSet oldRoutes = new HashSet();
        oldRoutes.addAll(this.routes);
        this.routes.clear();
        for (Map.Entry temp : results.entrySet()) {
            String sid = temp.getKey() + "";
            Map session = (Map)temp.getValue();
            if ("".equals(session.get("routes") + "")) continue;
            String[] routez = (session.get("routes") + "").split(",");
            for (int x = 0; x < routez.length; ++x) {
                String[] zz = routez[x].split("/");
                this.routes.add(new Route(zz[0], zz[1], sid));
            }
        }
        HashSet currentRoutes = new HashSet();
        currentRoutes.addAll(this.routes);
        Set newRoutes = DataUtils.difference(currentRoutes, oldRoutes);
        this.fireRouteEvents("route_add", newRoutes.iterator());
        Set goneRoutes = DataUtils.difference(oldRoutes, currentRoutes);
        this.fireRouteEvents("route_delete", goneRoutes.iterator());
        Stack<Scalar> arg = new Stack<Scalar>();
        arg.push(FilterManager.convertAll(this.routes));
        this.manager.fireEventAsync("routes", arg);
        this.initial = false;
    }
}

