/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.util.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.msgpack.MessagePack;
import org.msgpack.type.Value;
import org.msgpack.type.ValueFactory;
import org.msgpack.unpacker.Converter;

public class JSONUnpacker
extends Converter {
    protected Reader in;
    private JSONParser parser;

    public JSONUnpacker(InputStream in) {
        this(new MessagePack(), in);
    }

    public JSONUnpacker(MessagePack msgpack, InputStream in) {
        this(msgpack, new InputStreamReader(in));
    }

    public JSONUnpacker(MessagePack msgpack, InputStream in, Charset cs) {
        this(msgpack, new InputStreamReader(in, cs));
    }

    JSONUnpacker(MessagePack msgpack, Reader in) {
        super(msgpack, null);
        this.in = in;
        this.parser = new JSONParser();
    }

    @Override
    protected Value nextValue() throws IOException {
        try {
            Object obj = this.parser.parse(this.in);
            return this.objectToValue(obj);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    private Value objectToValue(Object obj) {
        if (obj instanceof String) {
            return ValueFactory.createRawValue((String)obj);
        }
        if (obj instanceof Integer) {
            return ValueFactory.createIntegerValue((Integer)obj);
        }
        if (obj instanceof Long) {
            return ValueFactory.createIntegerValue((Long)obj);
        }
        if (obj instanceof Map) {
            return this.mapToValue((Map)obj);
        }
        if (obj instanceof List) {
            return this.listToValue((List)obj);
        }
        if (obj instanceof Boolean) {
            return ValueFactory.createBooleanValue((Boolean)obj);
        }
        if (obj instanceof Double) {
            return ValueFactory.createFloatValue((Double)obj);
        }
        return ValueFactory.createNilValue();
    }

    private Value listToValue(List list) {
        Value[] array2 = new Value[list.size()];
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = this.objectToValue(list.get(i));
        }
        return ValueFactory.createArrayValue(array2, true);
    }

    private Value mapToValue(Map map2) {
        Value[] kvs = new Value[map2.size() * 2];
        Iterator it = map2.entrySet().iterator();
        for (int i = 0; i < kvs.length; i += 2) {
            Map.Entry pair = it.next();
            kvs[i] = this.objectToValue(pair.getKey());
            kvs[i + 1] = this.objectToValue(pair.getValue());
        }
        return ValueFactory.createMapValue(kvs, true);
    }

    @Override
    public int getReadByteCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void resetReadByteCount() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        super.close();
    }
}

