#
# Copyright (c) 2006-2024 Wade Alcorn - wade@bindshell.net
# Browser Exploitation Framework (BeEF) - https://beefproject.com
# See the file 'doc/COPYING' for copying permission
#
class Qemu_monitor_migrate_cmd_exec < BeEF::Core::Command
  def self.options
    configuration = BeEF::Core::Configuration.instance
    lhost = configuration.beef_host
    lhost = '' if lhost == '0.0.0.0'

    [
      { 'name' => 'rhost', 'ui_label' => 'Remote Host', 'value' => '127.0.0.1' },
      { 'name' => 'rport', 'ui_label' => 'Remote Port', 'value' => '' },
      { 'name' => 'payload',
        'type' => 'combobox',
        'ui_label' => 'Payload',
        'store_type' => 'arraystore',
        'store_fields' => ['payload'],
        'store_data' => [['reverse_bash'], ['reverse_netcat'], ['reverse_python2'], ['reverse_ruby']],
        'emptyText' => 'Select a payload',
        'valueField' => 'payload',
        'displayField' => 'payload',
        'mode' => 'local',
        'forceSelection' => 'false',
        'autoWidth' => true },
      { 'name' => 'lhost', 'ui_label' => 'Listen Host', 'value' => lhost },
      { 'name' => 'lport', 'ui_label' => 'Listen Port', 'value' => '8080' }
    ]
  end

  def post_execute
    save({ 'result' => @datastore['result'] })
  end
end
